# coding: utf-8
import datetime
import httplib2
import urllib
from xml.dom import minidom
#from xml.dom.minidom import parseString
 
class Holiday:
    def __init__(self,date_string,name):
        self.date_string = date_string
        self.name = name
        d = date_string.split('-')
        self.date = datetime.date(int(d[0]),int(d[1]),int(d[2]))
    def __repr__(self):
        return self.date_string + ' ' + self.name
 
def get_japan_holiday(start,days,range):
    """
    start :いつから　datetimeオブジェクトで渡す
    days:調べたい期間を 日数で渡す
    range:listで返ってくる祝日の要素数　
　  大きくするとgoogleがエラーを返すのか？　未確認
    """
    end = start + datetime.timedelta(days)
    host = "http://www.google.com/calendar/feeds/"
    user = "ja.japanese%23holiday@group.v.calendar.google.com"
    param = "/public/full"
    val = {"start-min" : start.strftime("%Y-%m-%d"),
    "start-max" : end.strftime("%Y-%m-%d"),
    "max-results" : str(range)}
    http = httplib2.Http()
    url = "%s%s%s?%s" % (host, user, param, urllib.urlencode(val))
    response,content = http.request(url)
    #print parseString(content).toprettyxml(encoding="utf-8")
    xdoc = minidom.parseString(content)
    elements = xdoc.getElementsByTagName("entry")
    holidays = []
    for element in elements:
        day = holiday_name = ''
        for child in element.childNodes:
            if child.tagName == 'gd:when':
                day = child.getAttribute('startTime')
            if child.tagName == "title":
                holiday_name = child.firstChild.data
        holidays.append(Holiday(day,holiday_name))
         
    sorted_holidays = sorted(holidays,key=lambda holiday:(holiday.date.year,holiday.date.month,holiday.date.day))
 
    return sorted_holidays
 
if __name__=="__main__":
    now = datetime.datetime(2013,1,1)
    print get_japan_holiday(now,365*2,100)

print 
