#!/usr/bin/env python
#coding: utf-8
import pygame
from pygame.locals import *
import os
import sys
import random
SCR_RECT = Rect(0, 0, 640, 480)
yy = 0
def main():
    pygame.init()
    screen = pygame.display.set_mode(SCR_RECT.size)
    Player.shot_sound = load_sound("shot.ogg")
    all = pygame.sprite.RenderUpdates()
    player = pygame.sprite.Group()
    tekis = pygame.sprite.Group()
    shots = pygame.sprite.Group()
    Player.containers = all,player
    Shot.containers = all,shots
    Teki.containers = all,tekis
    backg=load_image("j.jpg")
    Player.image = load_image("ojizousan3.png")
    Shot.image = load_image("isi.png")
    Teki.image = load_image("teki.png")
    playerss= Player()
    teki1 = Teki(688,100,1,2)
    teki2 = Teki(688,200,1,2)
    teki3 = Teki(888,100,1,2)
    teki4 = Teki(1088,400,1,2)
    teki5 = Teki(1488,100,1,2)
    teki6 = Teki(1268,200,1,2)
    
    
    clock = pygame.time.Clock()
    while True:
        clock.tick(60)
        playerss.collision_detection(shots,tekis)
        playerss.collision_detection2(tekis,player)
        screen.fill((0, 0, 0))
        screen.blit(backg,(0,0))
        font = pygame.font.Font("VL-Gothic-Regular.ttf",32)
        text = font.render(str(playerss.score),False,(0,0,0))
        screen.blit(text,(356,39))
        text = font.render("SCORE",False,(0,0,0))
        screen.blit(text,(256,39))
        print(playerss.score)
        all.update()
        all.draw(screen)
        pygame.display.update()
        for event in pygame.event.get():
            if event.type == QUIT:
                pygame.quit()
                sys.exit()
            elif event.type == KEYDOWN and event.key == K_ESCAPE:
                pygame.quit()
                sys.exit()



class Player(pygame.sprite.Sprite):
    speed = 5 
    reload_time = 10
    def __init__(self):
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.score = 0
        self.rect = self.image.get_rect()
        self.rect.left = SCR_RECT.left  
        self.reload_timer = 0
        self.score = 0
    def update(self):
        pressed_keys = pygame.key.get_pressed()
        if pressed_keys[K_UP]:
            self.rect.move_ip(0,-self.speed)
        elif pressed_keys[K_DOWN]:
            self.rect.move_ip(0, self.speed)
        self.rect.clamp_ip(SCR_RECT)
        if pressed_keys[K_SPACE]:
            if self.reload_timer > 0:
                self.reload_timer -= 1
            else:
                Player.shot_sound.play()
                Shot(self.rect.center) 
                self.reload_timer = self.reload_time
    def collision_detection(self,shots, aliens):
        alien_collided = pygame.sprite.groupcollide(aliens, shots, True, True)
        for shots in alien_collided.keys():
            self.score = self.score + 1
    def collision_detection2(self,shots, aliens):
        alien_collided = pygame.sprite.groupcollide(aliens, shots, True, True)
        for shots in alien_collided.keys():
            exit()
class Teki(pygame.sprite.Sprite):
    speed = 1  
    reload_time = 15  
    def __init__(self,x,y,width,height):
        pygame.sprite.Sprite.__init__(self, self.containers)
        width=self.image.get_width()
        height=self.image.get_height()
        self.rect =Rect(x,y,width,height)
        self.reload_timer = 0
        self.vx=0
        self.vy=0
    def update(self):
        self.rect.right -= 5
        if self.rect.right == 0:
            self.rect.right=498
    def draw(self,screen):
        screen.blit(self.image,self.rect)


class Shot(pygame.sprite.Sprite):
    speed = 9 
    def __init__(self, pos):
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.rect = self.image.get_rect()
        self.rect.center = pos  
    def update(self):
        self.rect.move_ip(self.speed,0)# 
        if self.rect.top < 0:
            self.kill()


def load_image(filename, colorkey=None):
    filename = os.path.join("data", filename)
    try:
        image = pygame.image.load(filename)
    except pygame.error as message:
        print("Cannot load image:", filename)
        raise SystemExit(message)
    image = image.convert_alpha()
    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0,0))
        image.set_colorkey(colorkey, RLEACCEL)
    return image

def load_sound(filename):
    filename = os.path.join("data", filename)
    return pygame.mixer.Sound(filename)

if __name__ == "__main__":
    main()

